(defmeth homals-proto :Report
  (&key (stream t) 
        (dialog nil))
  (if (not (eq current-object self)) (setcm self))
  (let* ((w nil)
         (point-labels (send self :labels))
(category-labels (combine (send self :category-labels)))

         (var-labels (send self :variables))
         (scores (send self :slot-value 'Z))
         (quantification  (send self :slot-value 'Y))
         (d-m-cols (make-array '(3 5) :initial-contents (combine (mapcar 'diagonal (send self :d-m)))))
         (eigenvalues (make-array '(5 1) :initial-contents (mapcar #'mean (column-list d-m-cols))))
         (Dim-Labels (mapcar #'(lambda (x) (format nil " Dim ~a  " x))(+ 1 (iseq (send self :p)))))
        (Choice
              (choose-subset-dialog
               "Homogeneity Analysis Report"
               '("Object Scores"
                 "Category Quantifications"
                 "Discrimination Measures"
                 "Summary") ))
)

    

(when Choice
          (setf w (report-header (send self :title " Homogeneity Analysis Report")))
          
          (display-string
           (format nil "~%---------------------------------------------------------------------~2%                  HOMOGENEITY ANALYSIS REPORT~2%---------------------------------------------------------------------~2%MODEL: ~a~2%" (send self :name)) w)
          (display-string
           (format nil "VARIABLES: ~a~2%" var-labels ) w)
          (when (member '0 (select Choice 0))
                (display-string
                 (format nil "~%---------------------------------------------------------------------~%                        OBJECT SCORES~%---------------------------------------------------------------------~%") w)
                (print-matrix-to-window scores  w  :row-heading "-Object-" :column-heading "" :column-labels Dim-Labels :decimals 3))

          (when (member '1 (select Choice 0))
                (display-string
                 (format nil "~%----------------------------------------------------------------------~%                    CATEGORY QUANTIFICATIONS~%----------------------------------------------------------------------~%") w)
                (print-matrix-to-window quantification w :row-heading "-Category-" :column-heading "" :row-labels category-labels :column-labels Dim-Labels :decimals 3))

          (when (member '2 (select Choice 0))
                (display-string
                 (format nil "~%---------------------------------------------------------------------~%                DISCRIMINATION MEASURES~%---------------------------------------------------------------------~%") w)
                (print-matrix-to-window d-m-cols w :row-heading "-Var-" :column-heading "" :labels var-labels :column-labels Dim-Labels :decimals 3)      
                 (display-string
          (format nil "~%---------------------------------------------------------------------~%                 AVERAGE DISCRIMINATION MEASURES~%---------------------------------------------------------------------~%") w)
                (print-matrix-to-window eigenvalues w :row-heading "-DIM-" :column-labels NIL  :labels Dim-Labels :column-heading "" :decimals 3)  
 )
         
          (when (member '3 (select Choice 0))
                (display-string
                 (format nil "~%---------------------------------------------------------------------~%                         OBJECT SCORES~% --------------------------------------------------------------------~%") w)
                (print-matrix-to-window scores w :row-heading "-Object-" :column-heading "" :column-labels Dim-Labels :decimals 3)
                (display-string
                 (format nil "~%--------------------------------------------------------------------~%                    CATEGORY QUANTIFICATIONS~%--------------------------------------------------------------------~%") w)
                (print-matrix-to-window quantification w :row-heading "-Category-" :column-heading "" :column-labels Dim-Labels :row-labels category-labels :decimals 3)
                
                (display-string
                 (format nil "~%---------------------------------------------------------------------~%                    DISCRIMINATION MEASURES~%---------------------------------------------------------------------~%") w)
                (print-matrix-to-window d-m-cols w :row-heading "-Var-" :column-heading "" :column-labels Dim-Labels :labels var-labels :decimals 3)
                (display-string
          (format nil "~%---------------------------------------------------------------------~%                   AVERAGE DISCRIMINATION MEASURES~%---------------------------------------------------------------------~%") w)
                (print-matrix-to-window eigenvalues w :row-heading "-DIM-" :column-labels NIL  :labels Dim-Labels :column-heading "" :decimals 3) 
                )
     )
   
 (send w :fit-window-to-text)
 ))